<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$message = '';
$message_type = '';

// Get order ID from URL
$order_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($order_id > 0) {
    try {
        $conn = getAdminDBConnection();

        // Prepare a delete statement
        $stmt = $conn->prepare("DELETE FROM orders WHERE id = ?");
        if ($stmt === false) {
            throw new Exception('Prepare delete statement failed: ' . $conn->error);
        }

        $stmt->bind_param('i', $order_id);

        if ($stmt->execute()) {
            if ($stmt->affected_rows > 0) {
                $message = 'تم حذف الطلب بنجاح!';
                $message_type = 'success';
            } else {
                $message = 'الطلب المطلوب غير موجود أو تم حذفه مسبقًا.';
                $message_type = 'warning';
            }
        } else {
            $message = 'حدث خطأ أثناء حذف الطلب: ' . $conn->error;
            $message_type = 'danger';
        }
        $stmt->close();
    } catch (Exception $e) {
        $message = 'خطأ: ' . $e->getMessage();
        $message_type = 'danger';
    } finally {
        if (isset($conn) && $conn) {
            $conn->close();
        }
    }
} else {
    $message = 'معرف الطلب غير صالح للحذف.';
    $message_type = 'danger';
}

// Redirect back to admin_orders.php with a message
header('Location: admin_orders.php?message=' . urlencode($message) . '&type=' . $message_type);
exit();
?>

<div class="container bg-dark text-white mt-5">
</div> 